import java.util.Arrays;

class Main {
  public static void main(String[] args) {
    In in = new In();
    Out out = new Out();
    out.SysInit(); 
    test(in, out);
  }
  
  public static void test(In in, Out out) {
    // Uncomment the following two lines if you want to read from a file
    in.open("public/custom.in");
    out.compareTo("public/custom.out");
    
    int testNum = in.readInt(); // read the number of tests
    for (int i = 0; i < testNum; i++) {
      int arrLength = in.readInt();
      int[] cost = new int[arrLength];
      for (int j=0; j<arrLength; j++) {
        cost[j] = in.readInt();
      }
      if (arrLength <= 10) {
        System.out.println("Considering array: \n" + Arrays.toString(cost));
      }
      int res = minCostClimbingStairs(cost);
      out.println(res);
    }
  }
  
  public static int minCostClimbingStairs(int[] cost) {
    // (1) Initialize DP table
    // Meaning of DP[i]: minCost to get to i-th step
    int n = cost.length;
    int[] DP = new int[n+1];
    
    // (2) Fill in base cases
    // The problem states that we can start on the first or second step
    // => start on 0-th step or 1-st step, each with cost 0
    DP[0] = 0; // 
    DP[1] = 0;
    
    // (3) Compute Entries
    // Recursion: DP[i] = minimum of (i) cost to step i-1 + cost of step i-1 & (ii) cost to step i-2 + cost of step i-2
    for (int i=2; i<n+1; i++) {
      DP[i] = Math.min(DP[i-1]+cost[i-1], DP[i-2]+cost[i-2]);
    }
    
    // (4) Extract Result
    // DP[n] = min cost to get to n-th step (note: the n-th step is the top)
    return DP[n];
  }
}