import java.util.ArrayList;

class Main {
  public static void main(String[] args) {
    In in = new In();
    Out out = new Out();
    out.SysInit(); 
    test(in, out);
  }
  
  public static void test(In in, Out out) {
    in.open("public/custom.in");
    out.compareTo("public/custom.out");
    int testNum = in.readInt(); // number of tests
    for (int test = 0; test < testNum; test++) {
      int n = in.readInt();
      int m = in.readInt();

      ArrayList<ArrayList<Integer>> E = new ArrayList<ArrayList<Integer>>(n);
      for (int i = 0; i < n; i++) { // initialization with empty arrays
        E.add(new ArrayList<Integer>());
      }
      for (int i = 0; i < m; i++) { // read edges
        int u = in.readInt();
        int v = in.readInt();
        E.get(u).add(v);
        E.get(v).add(u);
      }
      out.println(eulerian(n, m, E));
    }
  }

  /* Problem Statement:
  ------------------------------------------------------------------------------------------------
  You are given a graph in the form of an adjacency list, where each vertex is represented by a
  natural number 0 ≤ v ≤ n − 1, n = |V |, and the neighbors of v can be accessed through
  E .get(v ) (returns a list of the neighboring vertices).
  Implement the eulerian() method such that it determines if the given graph is Eulerian or not.
  Note, one condition requires you to check the connectedness, which you have not looked at
  in the lecture yet. However, the algorithm to do so is quite intuitive. Give it a shot!
  */
  
  // E is the adjacency list representation!
  // E.get(i).get(j) is the j-th neighbor of vertex i
  // E.get(i).size() is the number of neighbors of vertex i
  public static boolean eulerian(int n, int m, ArrayList<ArrayList<Integer>> E) {
    // TODO
    // What are the necessary and sufficient conditions for an Eulerian graph?
    // Think about how you can check these properties.
    // Hint: You need to count sth.
    return true;
  }
  
  /* You have technically not yet learned about how to perform a DFS (part of this week's lecture)
    Still, it's a fairly intuitive algorithm. Try to implement a recursive algorithm that visits
    all neighbors of a vertex and keeps track of which one's it's already visited.
  */
  public static void connected(int curr, boolean[] visited, ArrayList<ArrayList<Integer>> E) {
    // TODO
    // If visited...
    
    // Else...
  }
}