import java.util.ArrayList;

class Main {
  public static void main(String[] args) {
    In in = new In();
    Out out = new Out();
    out.SysInit(); 
    test(in, out);
  }
  
   public static void test(In in, Out out) {
        in.open("public/custom.in");
        out.compareTo("public/custom.out");
        int numTests = in.readInt();
        
        for (int t = 0; t < numTests; t++) {
            int n = in.readInt(); 
            int m = in.readInt(); 
            int operation = in.readInt();
            
            int queryU = -1;  
            int queryV = -1;  
            if (operation == 1) {  
                queryU = in.readInt();
                queryV = in.readInt();
            }
            
            ArrayList<ArrayList<Integer>> E = new ArrayList<>();
            for (int i = 0; i < n; i++) {
                E.add(new ArrayList<>());
            }
            
            for (int i = 0; i < m; i++) {
                int u = in.readInt();
                int v = in.readInt();
                E.get(u).add(v);
                E.get(v).add(u);
            }
            
            switch (operation) {
                case 0: 
                    boolean hasCycle = hasCycle(n, E);
                    out.println(hasCycle ? "true" : "false");
                    break;
                    
                case 1: 
                    boolean reachable = isReachable(n, E, queryU, queryV);  
                    out.println(reachable ? "true" : "false");
                    break;
                    
                case 2: 
                    int numComponents = countComponents(n, E);
                    out.println(numComponents);
                    break;
                    
                default:
                    out.println("Unknown operation");
            }
        }
    }
    
    // ==========================================================================================
    // Exercise 1 - Cycle Detection
    // ==========================================================================================
    
    public static boolean hasCycle(int n, ArrayList<ArrayList<Integer>> E) {
        // TODO: Implement cycle detection
        return false;
    }
    
    public static boolean solveCycle(int curr, int par, boolean[] visited, ArrayList<ArrayList<Integer>> E) {
      // TODO
    }
  
    // ==========================================================================================
    // Exercise 2 - Reachability
    // ==========================================================================================
  
   // Determine if there is a path from u to v.
   // E = Adjacency list representation of the undirected graph
   // u = source vertex, v Target vertex
    public static boolean isReachable(int n, ArrayList<ArrayList<Integer>> E, int u, int v) {
        // TODO
    }
    
    public static boolean reaches(int curr, int target, boolean[] visited, ArrayList<ArrayList<Integer>> E) {
      // TODO: Implement reachability check
    }
    
    // ==========================================================================================
    // Exercise 3 - Component Counting
    // ==========================================================================================
    
    // // E = Adjacency list representation of the graph
    public static int countComponents(int n, ArrayList<ArrayList<Integer>> E) {
        // TODO: Implement component counting
        return 0;
    }
    
    public static void solveCount(int curr, boolean[] visited, ArrayList<ArrayList<Integer>> E) {
      // TODO
    }
}